/*  Copyright 2008 Theo Berkau

    This file is part of Yabause.

    Yabause is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Yabause is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Yabause; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
*/
#pragma optimize( "", on )
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <malloc.h>
#include <xtl.h>
#include "../cs0.h"
#include "../m68kcore.h"
#include "../peripheral.h"
#include "vidxbs.h"
#include "vidxgl.h"
#include "../vdp2.h"
#include "../vdp1.h"
#include "../yui.h"
//#include "persdlx.h"
#include "perxbox.h"
#include "snddx.h"
//#include "../sndsdl.h"
#include "../ygl.h"
#include "inifile.h"
#include "iosupport.h"

volatile int done=0;
volatile int resetemu=0;
int running=1;

SH2Interface_struct *SH2CoreList[] = {
&SH2Interpreter,
//&SH2DebugInterpreter,
NULL
};

PerInterface_struct *PERCoreList[] = {
&PERDummy,
//&PERSDLX,
&PERXBOX,
NULL
};

CDInterface *CDCoreList[] = {
&DummyCD,
&ISOCD,
NULL
};

SoundInterface_struct *SNDCoreList[] = {
&SNDDummy,
&SNDDIRECTX,
//&SNDSDL,
NULL
};

VideoInterface_struct *VIDCoreList[] = {
&VIDDummy,
&VIDXGL, //Not working :-(
&VIDXBS,
NULL
};

M68K_struct *M68KCoreList[] = {
&M68KDummy,
&M68KC68K,
#ifdef HAVE_Q68
&M68KQ68,
#endif
NULL
};

/*static char bupfilename[512]="D:\\Data\\Systems\\SAT\\Roms\\bkram.bin";
static char biosfilename[512]="D:\\Data\\Systems\\SAT\\Bios\\bios.bin";
//static char isofilename[512]="D:\\Roms\\game.cue";
static char cartfilename[512]="D:\\Data\\Systems\\SAT\\Roms\\bkram32M.bin";*/

// should not need the data dir on xbox
static char bupfilename[512]="D:\\Systems\\SAT\\Roms\\bkram.bin";
static char biosfilename[512]="D:\\Systems\\SAT\\Bios\\bios.bin";
//static char isofilename[512]="D:\\Systems\\SAT\\Roms\\game.cue";
static char cartfilename[512]="D:\\Systems\\SAT\\Roms\\bkram32M.bin";


void reset()
{
   resetemu=1;
}

void powerdown()
{
   done = 1;
}


int YuiExec()
{
   yabauseinit_struct yinit;
   int ret;

   memset(&yinit, 0, sizeof(yabauseinit_struct));
   yinit.percoretype = PERCORE_XBOX;
   yinit.sh2coretype = SH2CORE_INTERPRETER;
   yinit.vidcoretype = VIDCORE_XBS;//VIDCORE_XBS;//VIDCORE_XGL; //OGL unsupported on XBOX
   yinit.sndcoretype = SNDCORE_DIRECTX;//SNDCORE_SDL;
   yinit.cdcoretype = CDCORE_ISO;
   yinit.m68kcoretype = M68KCORE_C68K;
   yinit.carttype = CART_DRAM32MBIT;//CART_BACKUPRAM32MBIT;
   yinit.regionid = REGION_AUTODETECT;
   if (strcmp(biosfilename, "") == 0){
	   yinit.biospath = NULL;}
   else{
	   yinit.biospath = biosfilename;}
   yinit.cdpath = g_iniFile.szTempRomFileName.c_str();//isofilename;
   yinit.buppath = bupfilename;
   //yinit.buppath = NULL;
   yinit.mpegpath = NULL;
   //yinit.cartpath = NULL;
   yinit.cartpath = cartfilename;
   yinit.netlinksetting = NULL;
   yinit.videoformattype = VIDEOFORMATTYPE_NTSC;
   yinit.usethreads = 0;

   // Hijack the fps display
   // FIXME: This does not work
   //VIDXBS.OnScreenDebugMessage = OnScreenDebugMessage;

   if ((ret = YabauseInit(&yinit)) == 0)
   {

	   if(g_iniFile.m_currentIniEntry.bShowDebugInfo)
	   {
			ToggleFPS();
	   }
		
	   //Check for speed throttle
	   if(g_iniFile.m_currentIniEntry.bManualFrameSkip)
	   {
		   SpeedThrottleEnable();
	   }else{
		   SpeedThrottleDisable();
	   }

	   //Check for automatic frame skip
	   if(g_iniFile.m_currentIniEntry.bAutomaticFrameSkip)
	   {
		   EnableAutoFrameSkip();
	   }else{
		   DisableAutoFrameSkip();
	   }

	   //Check for sync setting, set to 1 -> Sync Audio to Video (slow Audio!) 
	   ScspSetFrameAccurate(g_iniFile.m_currentIniEntry.bSyncAudioToVideo);

	   if(g_iniFile.m_currentIniEntry.bHideNBG0)
	   {
			ToggleNBG0();
	   }

	   if(g_iniFile.m_currentIniEntry.bHideNBG1)
	   {
			ToggleNBG1();
	   }

	   if(g_iniFile.m_currentIniEntry.bHideNBG2)
	   {
			ToggleNBG2();
	   }

	   if(g_iniFile.m_currentIniEntry.bHideNBG3)
	   {
			ToggleNBG3();
	   }

	   if(g_iniFile.m_currentIniEntry.bHideRBG0)
	   {
			ToggleRBG0();
	   }

	   if(g_iniFile.m_currentIniEntry.bHideVDP1)
	   {
			ToggleVDP1();
	   }


      while(!done)
      {
         if (PERCore->HandleEvents() != 0)
            return -1;
         if (resetemu)
         {
            YabauseReset();
            resetemu = 0;
         }
      }
      YabauseDeInit();
   }
   else
   {
      while(!done)
	  {}
   }

return 0;   
}

void YuiErrorMsg(const char *string)
{/*
   if (strncmp(string, "Master SH2 invalid opcode", 25) == 0)
   {
      if (!running)
         return;
      running = 0;
      printf("%s\n", string);
	  OutputDebugString(string);
	  OutputDebugString("\n");
   }*/
}

void YuiReleaseVideo()
{
}


int YuiSetVideoMode(int width, int height, int bpp, int fullscreen)
{
return 0;
}

void YuiSetVideoAttribute(int type, int val)
{
//nothing to do here
}


void YuiSwapBuffers()
{
}


int main(int argc, char **argv)
{

   XSetFileCacheSize(8 * 1024 * 1024);
   
   g_IOSupport.Mount("A:","cdrom0");
   g_IOSupport.Mount("E:","Harddisk0\\Partition1");
   g_IOSupport.Mount("Z:","Harddisk0\\Partition2");
   g_IOSupport.Mount("F:","Harddisk0\\Partition6");
   g_IOSupport.Mount("G:","Harddisk0\\Partition7");
   
   g_iniFile.LoadTempRomFileName();
   g_iniFile.CheckForIniEntry();
   YuiExec();
   exit(0);
   return 0;
}
